3544
((3) 0 () 5 ((q lib "openssl/sha1.rkt") (q lib "openssl/main.rkt") (q lib "openssl/md5.rkt") (q lib "openssl/libcrypto.rkt") (q lib "openssl/libssl.rkt")) () (h ! (equal) ((c def c (c (? . 0) q bytes->hex-string)) q (10835 . 3)) ((c def c (c (? . 3) q libcrypto-load-fail-reason)) q (11129 . 2)) ((c def c (c (? . 2) q md5)) q (10971 . 3)) ((c def c (c (? . 0) q sha1)) q (10716 . 3)) ((c def c (c (? . 1) q ssl-server-context-enable-ecdhe!)) q (9101 . 5)) ((c def c (c (? . 4) q libssl-load-fail-reason)) q (11273 . 2)) ((c def c (c (? . 0) q hex-string->bytes)) q (10904 . 3)) ((c def c (c (? . 1) q ssl-accept/enable-break)) q (3010 . 3)) ((c def c (c (? . 1) q ssl-max-client-protocol)) q (2087 . 3)) ((c def c (c (? . 1) q ssl-listener?)) q (2856 . 3)) ((c def c (c (? . 1) q ssl-abandon-port)) q (3118 . 3)) ((c def c (c (? . 1) q supported-server-protocols)) q (4209 . 4)) ((c def c (c (? . 1) q ssl-load-suggested-certificate-authorities!)) q (8487 . 8)) ((c def c (c (? . 1) q ssl-peer-verified?)) q (9943 . 3)) ((c def c (c (? . 1) q ssl-load-verify-root-certificates!)) q (7183 . 7)) ((c def c (c (? . 1) q ssl-load-certificate-chain!)) q (7752 . 6)) ((c def c (c (? . 1) q ssl-close)) q (2782 . 3)) ((c def c (c (? . 1) q ssl-peer-certificate-hostnames)) q (10148 . 3)) ((c def c (c (? . 1) q ssl-set-verify!)) q (9597 . 5)) ((c def c (c (? . 0) q sha1-bytes)) q (10773 . 3)) ((c def c (c (? . 1) q ssl-port?)) q (3424 . 3)) ((c def c (c (? . 1) q ssl-load-fail-reason)) q (34 . 2)) ((c def c (c (? . 1) q ssl-secure-client-context)) q (1133 . 2)) ((c def c (c (? . 1) q ssl-seal-context!)) q (7637 . 3)) ((c def c (c (? . 1) q ssl-make-server-context)) q (3479 . 13)) ((c def c (c (? . 2) q md5-bytes)) q (11027 . 3)) ((c def c (c (? . 1) q ssl-get-alpn-selected)) q (10635 . 3)) ((c def c (c (? . 1) q ssl-set-server-name-identification-callback!)) q (9348 . 5)) ((c def c (c (? . 1) q ssl-make-client-context)) q (1196 . 13)) ((c def c (c (? . 1) q ssl-set-ciphers!)) q (7482 . 4)) ((c def c (c (? . 1) q ssl-peer-check-hostname)) q (10237 . 4)) ((c def c (c (? . 1) q ssl-set-verify-hostname!)) q (10011 . 4)) ((c def c (c (? . 1) q ssl-peer-issuer-name)) q (10426 . 3)) ((c def c (c (? . 1) q ssl-try-verify!)) q (9770 . 5)) ((c def c (c (? . 1) q supported-client-protocols)) q (1861 . 4)) ((c def c (c (? . 1) q ssl-default-verify-sources)) q (6287 . 13)) ((c def c (c (? . 1) q ssl-available?)) q (0 . 2)) ((c def c (c (? . 3) q libcrypto)) q (11088 . 2)) ((c def c (c (? . 1) q ssl-client-context?)) q (2022 . 3)) ((c def c (c (? . 3) q openssl-lib-versions)) q (11186 . 2)) ((c def c (c (? . 1) q ssl-accept)) q (2915 . 3)) ((c def c (c (? . 1) q ssl-connect/enable-break)) q (669 . 11)) ((c def c (c (? . 1) q ssl-server-context-enable-dhe!)) q (8871 . 5)) ((c def c (c (? . 1) q ssl-channel-binding)) q (10506 . 4)) ((c def c (c (? . 1) q ssl-connect)) q (85 . 13)) ((c def c (c (? . 1) q ssl-server-context?)) q (4144 . 3)) ((c def c (c (? . 1) q ssl-dh4096-param-bytes)) q (9308 . 2)) ((c def c (c (? . 1) q ssl-load-default-verify-sources!)) q (7053 . 3)) ((c def c (c (? . 1) q ssl-addresses)) q (3181 . 6)) ((c def c (c (? . 1) q ssl-max-server-protocol)) q (4370 . 3)) ((c def c (c (? . 4) q libssl)) q (11235 . 2)) ((c def c (c (? . 1) q ssl-load-private-key!)) q (8040 . 10)) ((c def c (c (? . 1) q ssl-listen)) q (2178 . 14)) ((c def c (c (? . 1) q ports->ssl-ports)) q (4461 . 28)) ((c def c (c (? . 1) q ssl-peer-subject-name)) q (10345 . 3)) ((c def c (c (? . 1) q ssl-load-verify-source!)) q (5830 . 10))))
value
ssl-available? : boolean?
value
ssl-load-fail-reason : (or/c #f string?)
procedure
(ssl-connect  hostname                    
              port-no                     
             [client-protocol             
              #:alpn alpn-protocols]) -> input-port? output-port?
  hostname : string?
  port-no : (integer-in 1 65535)
  client-protocol : (or/c ssl-client-context?
                          'secure
                          'auto
                          'sslv2-or-v3 'sslv2 'sslv3 'tls 'tls11 'tls12)
                  = 'auto
  alpn-protocols : (listof bytes?) = null
procedure
(ssl-connect/enable-break  hostname          
                           port-no           
                          [client-protocol]) 
 -> input-port? output-port?
  hostname : string?
  port-no : (integer-in 1 65535)
  client-protocol : (or/c ssl-client-context?
                          'secure 'auto
                          'sslv2-or-v3 'sslv2 'sslv3 'tls 'tls11 'tls12)
                  = 'auto
procedure
(ssl-secure-client-context) -> ssl-client-context?
procedure
(ssl-make-client-context                                          
                         [protocol                                
                          #:private-key private-key               
                          #:certificate-chain certificate-chain]) 
 -> ssl-client-context?
  protocol : (or/c 'secure 'auto
                   'sslv2-or-v3 'sslv2 'sslv3 'tls 'tls11 'tls12)
           = 'auto
  private-key : (or/c (list/c 'pem path-string?) = #f
                      (list/c 'der path-string?)
                      #f)
  certificate-chain : (or/c path-string? #f) = #f
procedure
(supported-client-protocols)
 -> (listof (or/c 'secure 'auto
                  'sslv2-or-v3 'sslv2 'sslv3 'tls 'tls11 'tls12))
procedure
(ssl-client-context? v) -> boolean?
  v : any/c
procedure
(ssl-max-client-protocol)
 -> (or/c 'sslv2 'sslv3 'tls 'tls11 'tls12 #f)
procedure
(ssl-listen  port-no               
            [queue-k               
             reuse?                
             hostname-or-#f        
             server-protocol]) -> ssl-listener?
  port-no : listen-port-number?
  queue-k : exact-nonnegative-integer? = 5
  reuse? : any/c = #f
  hostname-or-#f : (or/c string? #f) = #f
  server-protocol : (or/c ssl-server-context?
                          'secure 'auto
                          'sslv2-or-v3 'sslv2 'sslv3 'tls 'tls11 'tls12)
                  = 'auto
procedure
(ssl-close listener) -> void?
  listener : ssl-listener?
procedure
(ssl-listener? v) -> boolean?
  v : any/c
procedure
(ssl-accept listener) -> input-port? output-port?
  listener : ssl-listener?
procedure
(ssl-accept/enable-break listener) -> input-port? output-port?
  listener : ssl-listener?
procedure
(ssl-abandon-port p) -> void?
  p : ssl-port?
procedure
(ssl-addresses p [port-numbers?])
 -> (or/c (values string? string?)
          (values string? port-number? string? listen-port-number?))
  p : (or/c ssl-port? ssl-listener?)
  port-numbers? : any/c = #f
procedure
(ssl-port? v) -> boolean?
  v : any/c
procedure
(ssl-make-server-context                                          
                         [protocol                                
                          #:private-key private-key               
                          #:certificate-chain certificate-chain]) 
 -> ssl-server-context?
  protocol : (or/c 'secure 'auto
                   'sslv2-or-v3 'sslv2 'sslv3 'tls 'tls11 'tls12)
           = 'auto
  private-key : (or/c (list/c 'pem path-string?) = #f
                      (list/c 'der path-string?)
                      #f)
  certificate-chain : (or/c path-string? #f) = #f
procedure
(ssl-server-context? v) -> boolean?
  v : any/c
procedure
(supported-server-protocols)
 -> (listof (or/c 'secure 'auto
                  'sslv2-or-v3 'sslv2 'sslv3 'tls 'tls11 'tls12))
procedure
(ssl-max-server-protocol)
 -> (or/c 'sslv2 'sslv3 'tls 'tls11 'tls12 #f)
procedure
(ports->ssl-ports  input-port                              
                   output-port                             
                  [#:mode mode                             
                   #:context context                       
                   #:encrypt protocol                      
                   #:close-original? close-original?       
                   #:shutdown-on-close? shutdown-on-close? 
                   #:error/ssl error                       
                   #:hostname hostname                     
                   #:alpn alpn-protocols])                 
 -> input-port? output-port?
  input-port : input-port?
  output-port : output-port?
  mode : (or/c 'connect 'accept) = 'accept
  context : (or/c ssl-client-context? ssl-server-context?)
          = ((if (eq? mode 'accept)
                 ssl-make-server-context
                 ssl-make-client-context)
             protocol)
  protocol : (or/c 'secure 'auto
                   'sslv2-or-v3 'sslv2 'sslv3 'tls 'tls11 'tls12)
           = 'auto
  close-original? : boolean? = #f
  shutdown-on-close? : boolean? = #f
  error : procedure? = error
  hostname : (or/c string? #f) = #f
  alpn-protocols : (listof bytes?) = null
procedure
(ssl-load-verify-source!  context           
                          src               
                         [#:try? try?]) -> void?
  context : (or/c ssl-client-context? ssl-server-context?)
  src : (or/c path-string?
              (list/c 'directory path-string?)
              (list/c 'win32-store string?)
              (list/c 'macosx-keychain path-string?))
  try? : any/c = #f
parameter
(ssl-default-verify-sources)
 -> (let ([source/c (or/c path-string?
                          (list/c 'directory path-string?)
                          (list/c 'win32-store string?)
                          (list/c 'macosx-keychain path-string?))])
      (listof source/c))
(ssl-default-verify-sources srcs) -> void?
  srcs : (let ([source/c (or/c path-string?
                               (list/c 'directory path-string?)
                               (list/c 'win32-store string?)
                               (list/c 'macosx-keychain path-string?))])
           (listof source/c))
procedure
(ssl-load-default-verify-sources! context) -> void?
  context : (or/c ssl-client-context? ssl-server-context?)
procedure
(ssl-load-verify-root-certificates! context-or-listener 
                                    pathname)           
 -> void?
  context-or-listener : (or/c ssl-client-conntext? ssl-server-context?
                              ssl-listener?)
  pathname : path-string?
procedure
(ssl-set-ciphers! context cipher-spec) -> void?
  context : (or/c ssl-client-context? ssl-server-context?)
  cipher-spec : string?
procedure
(ssl-seal-context! context) -> void?
  context : (or/c ssl-client-context? ssl-server-context?)
procedure
(ssl-load-certificate-chain! context-or-listener     
                             pathname)           -> void?
  context-or-listener : (or/c ssl-client-context? ssl-server-context?
                              ssl-listener?)
  pathname : path-string?
procedure
(ssl-load-private-key!  context-or-listener     
                        pathname                
                       [rsa?                    
                        asn1?])             -> void?
  context-or-listener : (or/c ssl-client-context? ssl-server-context?
                              ssl-listener?)
  pathname : path-string?
  rsa? : boolean? = #t
  asn1? : boolean? = #f
procedure
(ssl-load-suggested-certificate-authorities!                     
                                             context-or-listener 
                                             pathname)           
 -> void?
  context-or-listener : (or/c ssl-client-context? ssl-server-context?
                              ssl-listener?)
  pathname : path-string?
procedure
(ssl-server-context-enable-dhe!  context        
                                [dh-param]) -> void?
  context : ssl-server-context?
  dh-param : (or/c path-string? bytes?) = ssl-dh4096-param-bytes
procedure
(ssl-server-context-enable-ecdhe!  context          
                                  [curve-name]) -> void?
  context : ssl-server-context?
  curve-name : symbol? = 'secp521r1
value
ssl-dh4096-param-bytes : bytes?
procedure
(ssl-set-server-name-identification-callback! context       
                                              callback) -> void?
  context : ssl-server-context?
  callback : (string? . -> . (or/c ssl-server-context? #f))
procedure
(ssl-set-verify! clp on?) -> void?
  clp : (or/c ssl-client-context? ssl-server-context?
              ssl-listener? ssl-port?)
  on? : any/c
procedure
(ssl-try-verify! clp on?) -> void?
  clp : (or/c ssl-client-context? ssl-server-context?
              ssl-listener? ssl-port?)
  on? : any/c
procedure
(ssl-peer-verified? p) -> boolean?
  p : ssl-port?
procedure
(ssl-set-verify-hostname! ctx on?) -> void?
  ctx : (or/c ssl-client-context? ssl-server-context?)
  on? : any/c
procedure
(ssl-peer-certificate-hostnames p) -> (listof string?)
  p : ssl-port?
procedure
(ssl-peer-check-hostname p hostname) -> boolean?
  p : ssl-port?
  hostname : string?
procedure
(ssl-peer-subject-name p) -> (or/c bytes? #f)
  p : ssl-port?
procedure
(ssl-peer-issuer-name p) -> (or/c bytes? #f)
  p : ssl-port?
procedure
(ssl-channel-binding p type) -> bytes?
  p : ssl-port?
  type : (or/c 'tls-unique 'tls-server-end-point)
procedure
(ssl-get-alpn-selected p) -> (or/c bytes? #f)
  p : ssl-port?
procedure
(sha1 in) -> string?
  in : input-port?
procedure
(sha1-bytes in) -> bytes?
  in : input-port?
procedure
(bytes->hex-string bstr) -> string?
  bstr : bytes?
procedure
(hex-string->bytes str) -> bytes?
  str : string?
procedure
(md5 in) -> string?
  in : input-port?
procedure
(md5-bytes in) -> bytes?
  in : input-port?
value
libcrypto : (or/c #f ffi-lib?)
value
libcrypto-load-fail-reason : (or/c #f string?)
value
openssl-lib-versions : (listof string?)
value
libssl : (or/c #f ffi-lib?)
value
libssl-load-fail-reason : (or/c #f string?)
