(define unsafe-car #3%car)
(define unsafe-cdr #3%cdr)
(define unsafe-list-tail #3%list-tail)
(define unsafe-list-ref #3%list-ref)

(define unsafe-fx+ #3%fx+)
(define unsafe-fx- #3%fx-)
(define unsafe-fx* #3%fx*)
(define unsafe-fxquotient #3%fxquotient)
(define unsafe-fxremainder #3%fxremainder)
(define unsafe-fxmodulo #3%fxmodulo)
(define unsafe-fxabs #3%fxabs)
(define unsafe-fxand #3%fxand)
(define unsafe-fxior #3%fxior)
(define unsafe-fxxor #3%fxxor)
(define unsafe-fxnot #3%fxnot)
(define unsafe-fxrshift #3%fxarithmetic-shift-right)
(define unsafe-fxlshift #3%fxarithmetic-shift-left)

(define unsafe-fx= #3%fx=)
(define unsafe-fx< #3%fx<)
(define unsafe-fx> #3%fx>)
(define unsafe-fx>= #3%fx>=)
(define unsafe-fx<= #3%fx<=)
(define unsafe-fxmin #3%fxmin)
(define unsafe-fxmax #3%fxmax)

(define unsafe-fl+ #3%fl+)
(define unsafe-fl- #3%fl-)
(define unsafe-fl* #3%fl*)
(define unsafe-fl/ #3%fl/)
(define unsafe-flabs #3%flabs)

(define unsafe-fl= #3%fl=)
(define unsafe-fl< #3%fl<)
(define unsafe-fl> #3%fl>)
(define unsafe-fl>= #3%fl>=)
(define unsafe-fl<= #3%fl<=)
(define unsafe-flmin #3%flmin)
(define unsafe-flmax #3%flmax)

(define unsafe-fx->fl #3%fixnum->flonum)
(define unsafe-fl->fx #3%flonum->fixnum)

(define unsafe-flround #3%flround)
(define unsafe-flfloor #3%flfloor)
(define unsafe-flceiling #3%flceiling)
(define unsafe-fltruncate #3%fltruncate)

(define unsafe-flsin #3%flsin)
(define unsafe-flcos #3%flcos)
(define unsafe-fltan #3%fltan)
(define unsafe-flasin #3%flasin)
(define unsafe-flacos #3%flacos)
(define unsafe-flatan #3%flatan)
(define unsafe-fllog #3%fllog)
(define unsafe-flexp #3%flexp)
(define unsafe-flsqrt #3%flsqrt)
(define unsafe-flexpt #3%flexpt)

(define (unsafe-flrandom gen) (random gen))

(define unsafe-vector*-length #3%vector-length)
(define unsafe-vector*-ref #3%vector-ref)
(define unsafe-vector*-set! #3%vector-set!)
(define unsafe-vector*-cas! #3%vector-cas!)

(define unsafe-unbox* #3%unbox)
(define unsafe-set-box*! #3%set-box!)
(define unsafe-box*-cas! #3%box-cas!)

(define unsafe-bytes-length #3%bytevector-length)
(define unsafe-bytes-ref #3%bytevector-u8-ref)
(define unsafe-bytes-set! #3%bytevector-u8-set!)

(define unsafe-string-length #3%string-length)
(define unsafe-string-ref #3%string-ref)
(define unsafe-string-set! #3%string-set!)

(define unsafe-fxvector-length #3%fxvector-length)
(define unsafe-fxvector-ref #3%fxvector-ref)
(define unsafe-fxvector-set! #3%fxvector-set!)

(define (unsafe-s16vector-ref cptr k)
  (let ([mem (cpointer-memory cptr)])
    (if (bytes? mem)
        (bytevector-s16-native-ref mem k)
        (foreign-ref 'int16 mem k))))
(define (unsafe-s16vector-set! cptr k v)
  (let ([mem (cpointer-memory cptr)])
    (if (bytes? mem)
        (bytevector-s16-native-set! mem k v)
        (foreign-set! 'int16 mem k v))))

(define (unsafe-u16vector-ref cptr k)
  (let ([mem (cpointer-memory cptr)])
    (if (bytes? mem)
        (bytevector-u16-native-ref mem k)
        (foreign-ref 'uint16 mem k))))
(define (unsafe-u16vector-set! cptr k v)
  (let ([mem (cpointer-memory cptr)])
    (if (bytes? mem)
        (bytevector-u16-native-set! mem k v)
        (foreign-set! 'uint16 mem k v))))

(define (unsafe-f64vector-ref cptr k)
  (let ([mem (cpointer-memory cptr)])
    (if (bytes? mem)
        (bytevector-ieee-double-native-ref mem k)
        (foreign-ref 'double mem k))))
(define (unsafe-f64vector-set! cptr k v)
  (let ([mem (cpointer-memory cptr)])
    (if (bytes? mem)
        (bytevector-ieee-double-native-set! mem k v)
        (foreign-set! 'double mem k v))))

;; FIXME
(define (unsafe-f80vector-ref cptr k)
  (let ([mem (cpointer-memory cptr)])
    (if (bytes? mem)
        (bytevector-ieee-double-native-ref mem k)
        (foreign-ref 'double mem k))))
(define (unsafe-f80vector-set! cptr k v)
  (let ([mem (cpointer-memory cptr)])
    (if (bytes? mem)
        (bytevector-ieee-double-native-set! mem k v)
        (foreign-set! 'double mem k v))))

(define (unsafe-make-flrectangular r i)
  (#3%make-rectangular r i))
(define (unsafe-flreal-part c)
  (#3%real-part c))
(define (unsafe-flimag-part c)
  (#3%imag-part c))

(define unsafe-undefined (let ([p (make-record-type "undefined" '())])
                           ((record-constructor p))))

(define (check-not-unsafe-undefined v sym)
  (when (eq? v unsafe-undefined)
    (raise-arguments-error sym "undefined;\n cannot use before initialization"))
  v)

(define (check-not-unsafe-undefined/assign v sym)
  (when (eq? v unsafe-undefined)
    (raise-arguments-error sym "assignment disallowed;\n cannot assign before initialization"))
  v)
