4549
((3) 0 () 4 ((q lib "graphics/graphics.rkt") (q 756 . 5) (q 1240 . 6) (q lib "graphics/graphics-sig.rkt")) () (h ! (equal) ((c def c (c (? . 0) q struct:rgb)) c (? . 2)) ((c def c (c (? . 0) q get-key-press)) q (11315 . 3)) ((c def c (c (? . 0) q save-pixmap)) q (9454 . 5)) ((c def c (c (? . 0) q set-on-tick-event)) q (9730 . 7)) ((c def c (c (? . 0) q draw-string)) q (8139 . 8)) ((c def c (c (? . 0) q posn-y)) c (? . 1)) ((c def c (c (? . 0) q viewport-buffer-dc)) q (10483 . 3)) ((c def c (c (? . 0) q flip-rectangle)) q (3545 . 6)) ((c def c (c (? . 0) q viewport-flush-input)) q (11565 . 3)) ((c def c (c (? . 0) q draw-pixel)) q (2012 . 7)) ((c def c (c (? . 0) q clear-solid-ellipse)) q (6133 . 9)) ((c def c (c (? . 0) q posn)) c (? . 1)) ((c def c (c (? . 0) q draw-pixmap)) q (9208 . 8)) ((q def ((lib "graphics/graphics-unit.rkt") graphics@)) q (11719 . 2)) ((c def c (c (? . 0) q clear-pixel)) q (2225 . 4)) ((c def c (c (? . 0) q stop-tick)) q (9978 . 3)) ((c def c (c (? . 0) q struct:posn)) c (? . 1)) ((c def c (c (? . 0) q test-pixel)) q (1061 . 6)) ((c def c (c (? . 0) q get-string-size)) q (10194 . 4)) ((c def c (c (? . 0) q flip-viewport)) q (1837 . 3)) ((c def c (c (? . 0) q clear-line)) q (2645 . 5)) ((c def c (c (? . 0) q draw-polygon)) q (6779 . 8)) ((c def c (c (? . 0) q flip-pixel)) q (2318 . 4)) ((c def c (c (? . 0) q flip-line)) q (2760 . 5)) ((c def c (c (? . 0) q middle-mouse-click?)) q (11132 . 3)) ((q def ((lib "graphics/graphics-posn-less-unit.rkt") graphics-posn-less@)) q (11745 . 2)) ((c def c (c (? . 0) q set-on-key-event)) q (10050 . 4)) ((c def c (c (? . 0) q clear-solid-polygon)) q (7704 . 7)) ((c def c (c (? . 0) q close-graphics)) q (37 . 2)) ((c def c (c (? . 0) q ready-key-press)) q (11394 . 3)) ((c def c (c (? . 0) q get-mouse-click)) q (10573 . 3)) ((c def c (c (? . 0) q draw-rectangle)) q (2874 . 13)) ((c def c (c (? . 0) q draw-pixmap-posn)) q (8615 . 16)) ((c def c (c (? . 0) q viewport?)) q (701 . 3)) ((c def c (c (? . 0) q posn?)) c (? . 1)) ((c def c (c (? . 0) q make-rgb)) c (? . 2)) ((c def c (c (? . 0) q clear-viewport)) q (1760 . 3)) ((c def c (c (? . 0) q flip-solid-ellipse)) q (6458 . 9)) ((c def c (c (? . 0) q close-viewport)) q (626 . 3)) ((c def c (c (? . 0) q open-pixmap)) q (373 . 8)) ((c def c (c (? . 0) q copy-viewport)) q (1913 . 4)) ((c def c (c (? . 0) q draw-solid-ellipse)) q (5653 . 13)) ((c def c (c (? . 0) q open-viewport)) q (116 . 8)) ((c def c (c (? . 0) q default-display-is-color?)) q (1511 . 2)) ((c def c (c (? . 0) q get-color-pixel)) q (965 . 4)) ((c def c (c (? . 0) q flip-ellipse)) q (5445 . 6)) ((c form c (c (? . 3) q graphics^)) q (11646 . 2)) ((c def c (c (? . 0) q clear-rectangle)) q (3334 . 6)) ((c def c (c (? . 0) q get-pixel)) q (863 . 4)) ((c def c (c (? . 0) q init-world)) q (9638 . 4)) ((c def c (c (? . 0) q ready-mouse-click)) q (10656 . 3)) ((c def c (c (? . 0) q viewport-dc)) q (10400 . 3)) ((c def c (c (? . 0) q draw-ellipse)) q (4907 . 9)) ((c def c (c (? . 0) q rgb-green)) c (? . 2)) ((c def c (c (? . 0) q rgb)) c (? . 2)) ((c def c (c (? . 0) q flip-solid-rectangle)) q (4578 . 9)) ((c def c (c (? . 0) q clear-ellipse)) q (5236 . 6)) ((c def c (c (? . 0) q graphics-open?)) q (75 . 2)) ((c def c (c (? . 0) q flip-string)) q (8497 . 5)) ((c def c (c (? . 0) q draw-solid-polygon)) q (7330 . 11)) ((c def c (c (? . 0) q flip-solid-polygon)) q (7923 . 7)) ((c def c (c (? . 0) q make-posn)) c (? . 1)) ((c def c (c (? . 0) q rgb-red)) c (? . 2)) ((c def c (c (? . 0) q change-color)) q (1411 . 4)) ((c def c (c (? . 0) q viewport->snip)) q (10314 . 3)) ((c def c (c (? . 0) q right-mouse-click?)) q (11224 . 3)) ((c def c (c (? . 0) q draw-viewport)) q (1563 . 6)) ((c def c (c (? . 0) q query-mouse-posn)) q (10862 . 3)) ((c def c (c (? . 0) q posn-x)) c (? . 1)) ((c def c (c (? . 0) q open-graphics)) q (0 . 2)) ((c def c (c (? . 0) q clear-solid-rectangle)) q (4245 . 9)) ((c form c (c (? . 3) q graphics:posn^)) q (11680 . 2)) ((c def c (c (? . 0) q draw-line)) q (2410 . 8)) ((c def c (c (? . 0) q rgb-blue)) c (? . 2)) ((c def c (c (? . 0) q mouse-click-posn)) q (10956 . 3)) ((c def c (c (? . 0) q draw-solid-rectangle)) q (3755 . 13)) ((c def c (c (? . 0) q clear-string)) q (8378 . 5)) ((c def c (c (? . 0) q clear-polygon)) q (7043 . 5)) ((c def c (c (? . 0) q flip-polygon)) q (7187 . 5)) ((c def c (c (? . 0) q rgb?)) c (? . 2)) ((c def c (c (? . 0) q key-value)) q (11475 . 3)) ((c def c (c (? . 0) q left-mouse-click?)) q (11042 . 3)) ((c def c (c (? . 0) q ready-mouse-release)) q (10758 . 3))))
procedure
(open-graphics) -> void?
procedure
(close-graphics) -> void?
procedure
(graphics-open?) -> boolean?
procedure
(open-viewport name horiz vert) -> viewport?
  name : string?
  horiz : exact-nonnegative-integer?
  vert : exact-nonnegative-integer?
(open-viewport name dimensions) -> viewport?
  name : string?
  dimensions : posn?
procedure
(open-pixmap name horiz vert) -> viewport?
  name : string?
  horiz : exact-nonnegative-integer?
  vert : exact-nonnegative-integer?
(open-pixmap name dimensions) -> viewport?
  name : string?
  dimensions : posn?
procedure
(close-viewport viewport) -> void?
  viewport : viewport?
procedure
(viewport? v) -> boolean?
  v : any/c
struct
(struct posn (x y)
        #:extra-constructor-name make-posn)
  x : real?
  y : real?
procedure
((get-pixel viewport) p) -> (one-of/c 0 1)
  viewport : viewport?
  p : posn?
procedure
((get-color-pixel viewport) p) -> rgb?
  viewport : viewport?
  p : posn?
procedure
((test-pixel viewport) color) -> rgb?
  viewport : viewport?
  color : (or/c (integer-in 0 299)
                string?
                rgb?)
struct
(struct rgb (red green blue)
        #:extra-constructor-name make-rgb)
  red : (real-in 0 1)
  green : (real-in 0 1)
  blue : (real-in 0 1)
procedure
(change-color index rgb) -> void?
  index : (integer-in 0 299)
  rgb : rgb?
procedure
(default-display-is-color?) -> boolean?
procedure
((draw-viewport viewport) [color]) -> void?
  viewport : viewport?
  color : (or/c (integer-in 0 299) = "black"
                string?
                rgb?)
procedure
((clear-viewport viewport)) -> void?
  viewport : viewport?
procedure
((flip-viewport viewport)) -> void?
  viewport : viewport?
procedure
(copy-viewport source dest) -> void?
  source : viewport?
  dest : viewport?
procedure
((draw-pixel viewport) p [color]) -> void?
  viewport : viewport?
  p : posn?
  color : (or/c (integer-in 0 299) = "black"
                string?
                rgb?)
procedure
((clear-pixel viewport) p) -> void?
  viewport : viewport?
  p : posn?
procedure
((flip-pixel viewport) p) -> void?
  viewport : viewport?
  p : posn?
procedure
((draw-line viewport) p1 p2 [color]) -> void?
  viewport : viewport?
  p1 : posn?
  p2 : posn?
  color : (or/c (integer-in 0 299) = "black"
                string?
                rgb?)
procedure
((clear-line viewport) p1 p2) -> void?
  viewport : viewport?
  p1 : posn?
  p2 : posn?
procedure
((flip-line viewport) p1 p2) -> void?
  viewport : viewport?
  p1 : posn?
  p2 : posn?
procedure
((draw-rectangle  viewport)     
                  p             
                  width         
                  height        
                 [color])   -> void?
  viewport : viewport?
  p : posn?
  width : (and/c real? (not/c negative?))
  height : (and/c real? (not/c negative?))
  color : (or/c (integer-in 0 299) = "black"
                string?
                rgb?)
procedure
((clear-rectangle viewport) p width height) -> void?
  viewport : viewport?
  p : posn?
  width : (and/c real? (not/c negative?))
  height : (and/c real? (not/c negative?))
procedure
((flip-rectangle viewport) p width height) -> void?
  viewport : viewport?
  p : posn?
  width : (and/c real? (not/c negative?))
  height : (and/c real? (not/c negative?))
procedure
((draw-solid-rectangle  viewport)     
                        p             
                        width         
                        height        
                       [color])   -> void?
  viewport : viewport?
  p : posn?
  width : (and/c real? (not/c negative?))
  height : (and/c real? (not/c negative?))
  color : (or/c (integer-in 0 299) = "black"
                string?
                rgb?)
procedure
((clear-solid-rectangle viewport)     
                        p             
                        width         
                        height)   -> void?
  viewport : viewport?
  p : posn?
  width : (and/c real? (not/c negative?))
  height : (and/c real? (not/c negative?))
procedure
((flip-solid-rectangle viewport)     
                       p             
                       width         
                       height)   -> void?
  viewport : viewport?
  p : posn?
  width : (and/c real? (not/c negative?))
  height : (and/c real? (not/c negative?))
procedure
((draw-ellipse viewport) p width height [color]) -> void?
  viewport : viewport?
  p : posn?
  width : (and/c real? (not/c negative?))
  height : (and/c real? (not/c negative?))
  color : (or/c (integer-in 0 299) = "black"
                string?
                rgb?)
procedure
((clear-ellipse viewport) p width height) -> void?
  viewport : viewport?
  p : posn?
  width : (and/c real? (not/c negative?))
  height : (and/c real? (not/c negative?))
procedure
((flip-ellipse viewport) p width height) -> void?
  viewport : viewport?
  p : posn?
  width : (and/c real? (not/c negative?))
  height : (and/c real? (not/c negative?))
procedure
((draw-solid-ellipse  viewport)     
                      p             
                      width         
                      height        
                     [color])   -> void?
  viewport : viewport?
  p : posn?
  width : (and/c real? (not/c negative?))
  height : (and/c real? (not/c negative?))
  color : (or/c (integer-in 0 299) = "black"
                string?
                rgb?)
procedure
((clear-solid-ellipse viewport)     
                      p             
                      width         
                      height)   -> void?
  viewport : viewport?
  p : posn?
  width : (and/c real? (not/c negative?))
  height : (and/c real? (not/c negative?))
procedure
((flip-solid-ellipse viewport)     
                     p             
                     width         
                     height)   -> void?
  viewport : viewport?
  p : posn?
  width : (and/c real? (not/c negative?))
  height : (and/c real? (not/c negative?))
procedure
((draw-polygon viewport) points offset [color]) -> void?
  viewport : viewport?
  points : (listof posn?)
  offset : posn?
  color : (or/c (integer-in 0 299) = "black"
                string?
                rgb?)
procedure
((clear-polygon viewport) points offset) -> void?
  viewport : viewport?
  points : (listof posn?)
  offset : posn?
procedure
((flip-polygon viewport) points offset) -> void?
  viewport : viewport?
  points : (listof posn?)
  offset : posn?
procedure
((draw-solid-polygon  viewport)     
                      points        
                      offset        
                     [color])   -> void?
  viewport : viewport?
  points : (listof posn?)
  offset : posn?
  color : (or/c (integer-in 0 299) = "black"
                string?
                rgb?)
procedure
((clear-solid-polygon viewport)     
                      points        
                      offset)   -> void?
  viewport : viewport?
  points : (listof posn?)
  offset : posn?
procedure
((flip-solid-polygon viewport)     
                     points        
                     offset)   -> void?
  viewport : viewport?
  points : (listof posn?)
  offset : posn?
procedure
((draw-string viewport) p str [color]) -> void?
  viewport : viewport?
  p : posn?
  str : string?
  color : (or/c (integer-in 0 299) = "black"
                string?
                rgb?)
procedure
((clear-string viewport) p str) -> void?
  viewport : viewport?
  p : posn?
  str : string?
procedure
((flip-string viewport) p str) -> void?
  viewport : viewport?
  p : posn?
  str : string?
procedure
(((draw-pixmap-posn  file          
                    [type]))       
                     viewport)     
                     p             
                    [color])   -> void?
  file : path-string?
  type : (one-of/c 'unknown 'unknown/mask
                   'gif 'gif/mask 'jpeg 'png 'png/mask
                   'xbm 'xpm 'bmp)
       = 'unknown/mask
  viewport : viewport?
  p : posn?
  color : (or/c (integer-in 0 299) = "black"
                string?
                rgb?)
procedure
((draw-pixmap viewport) file p [color]) -> void?
  viewport : viewport?
  file : path-string?
  p : posn?
  color : (or/c (integer-in 0 299) = "black"
                string?
                rgb?)
procedure
((save-pixmap viewport) file [type]) -> void?
  viewport : viewport?
  file : path-string?
  type : (one-of/c 'gif 'jpeg 'png 'xbm 'xpm 'bmp) = 'xpm
procedure
((init-world viewport) v) -> void?
  viewport : viewport?
  v : any/c
procedure
((set-on-tick-event viewport)            
                    secs                 
                    update-callback) -> void?
  viewport : viewport?
  secs : real?
  update-callback : (any/c . -> . any/c)
procedure
((stop-tick viewport)) -> void?
  viewport : viewport?
procedure
((set-on-key-event viewport) key-callback) -> void?
  viewport : viewport?
  key-callback : (any/c any/c . -> . any/c)
procedure
((get-string-size viewport) str) -> (list/c real? real?)
  viewport : viewport?
  str : string?
procedure
(viewport->snip viewport) -> (is-a?/c snip%)
  viewport : viewport?
procedure
(viewport-dc viewport) -> (is-a?/c dc<%>)
  viewport : viewport?
procedure
(viewport-buffer-dc viewport) -> (is-a?/c dc<%>)
  viewport : viewport?
procedure
(get-mouse-click viewport) -> mouse-click?
  viewport : viewport?
procedure
(ready-mouse-click viewport) -> (or/c mouse-click? false/c)
  viewport : viewport?
procedure
(ready-mouse-release viewport) -> (or/c mouse-click? false/c)
  viewport : viewport?
procedure
(query-mouse-posn viewport) -> (or/c posn? false/c)
  viewport : viewport?
procedure
(mouse-click-posn mouse-click) -> posn?
  mouse-click : mouse-click?
procedure
(left-mouse-click? mouse-click) -> boolean?
  mouse-click : mouse-click?
procedure
(middle-mouse-click? mouse-click) -> boolean?
  mouse-click : mouse-click?
procedure
(right-mouse-click? mouse-click) -> boolean?
  mouse-click : mouse-click?
procedure
(get-key-press viewport) -> key-press?
  viewport : viewport?
procedure
(ready-key-press viewport) -> key-press?
  viewport : viewport?
procedure
(key-value key-press) -> (or/c char? symbol?)
  key-press : key-press?
procedure
(viewport-flush-input viewport) -> void?
  viewport : viewport?
signature
graphics^ : signature
signature
graphics:posn^ : signature
value
graphics@ : unit?
value
graphics-posn-less@ : unit?
