#lang scheme/base
(require scribble/core
         scribble/latex-properties
         setup/main-collects)

(provide scribble-file
         add-defaults)

(define (add-property properties pred new)
  (if (ormap pred properties)
      properties
      (cons new properties)))

(define (scribble-file s)
  (path->main-collects-relative (build-path (collection-path "scribble") s)))

(define (add-defaults doc pfx styl extras version?)
  (struct-copy part doc [style (make-style (style-name (part-style doc))
                                           ((if version? add-property (lambda (x y z) x))
                                            (add-property
                                             (style-properties (part-style doc))
                                             latex-defaults?
                                             (make-latex-defaults
                                              pfx
                                              styl
                                              extras))
                                            document-version?
                                            (make-document-version (version))))]))
