#lang scribble/doc
@(require "common.ss"
          scribble/struct)

@(define spacer (hspace 1))

@(define-syntax-rule (print-table [expr cons qq wr] ...)
  (*print-table (list (list spacer (racket expr) spacer (racketresult cons) spacer (racketresult qq) spacer (racketresult wr)) ...)))

@(define (*print-table rows)
   (make-table
    #f
    (cons
     (list (make-flow (list (make-paragraph (list spacer))))
           (make-flow (list @t{Input expression}))
           (make-flow (list (make-paragraph (list spacer))))
           (make-flow (list @t{@onscreen{Constructor}}))
           (make-flow (list (make-paragraph (list spacer))))
           (make-flow (list @t{@onscreen{Quasiquote}}))
           (make-flow (list (make-paragraph (list spacer))))
           (make-flow (list @t{@onscreen{write}})))
     (map (lambda (row)
            (map (lambda (e)
                   (make-flow (list (make-paragraph (list e)))))
                 row))
          rows))))

@title[#:tag "output-syntax"]{Output Printing Styles}

@section-index["printing format"]

Many Racket languages support a @onscreen{Output Syntax} choice that
determines how evaluation results are printed in the
@tech{interactions window}. This setting also applies to output
generated by calling @racket[print] explicitly.

The @onscreen{print} style is the normal Racket output style.  The
following table illustrates the other output styles:

@print-table[
[(cons 1 2) (cons 1 2) `(1 . 2) (1 . 2)]
[(list 1 2) (list 1 2) `(1 2) (1 2)]
['(1 2) (list 1 2) `(1 2) (1 2)]
[(list (void)) (list (void)) `(,(void)) (#,(@racketresultfont "#<void>"))]
[`(,(void)) (list (void)) `(,(void)) (#,(racketresultfont "#<void>"))]
[(vector 1 2 3) (vector 1 2 3) (vector 1 2 3) #(1 2 3)]
[(box 1) (box 1) (box 1) #&1]
[(lambda (x) x) (lambda (a1) ...) (lambda (a1) ...) #,(racketresultfont "#<procedure>")]
['sym 'sym 'sym sym]
[(make-s 1 2) (make-s 1 2) (make-s 1 2) #(struct:s 1 2)]
['() empty `() ()]
[add1 add1 add1 #,(racketresultfont "#<procedure:add1>")]
[(delay 1) (delay ...) (delay ...) #,(racketresultfont "#<promise>")]
[(regexp "a") (regexp "a") (regexp "a") #rx"a"]
]

The @as-index{@onscreen{Constructor} output} mode is similar to
Rackets normal print mode, except that even quotable are still printed
with constructors, constructor functions and forms are used to
approximate some otherwise unprintable values. For example,
@onscreen{Constructor} output prints a procedure in a
@racketresult[lambda] form. For output to a graphical context,
rational numbers are printed using a special @racket[snip%] object
that lets the user choose between improper fractions, mixed fractions,
and repeating decimals.

The @as-index{@onscreen{Quasiquote} output} mode is like
@onscreen{Constructor} output, but it uses @racket[quasiquote]
(abbreviated with @litchar{`}) to print lists, and it uses
@racket[unquote] (abbreviated with @litchar{,}) to escape back to
@onscreen{Constructor} printing as needed.

The @as-index{@onscreen{write} output} mode corresponds to traditional
Scheme printing via the @racket[write] procedure. For example, lists
print by parenthesizing the printed form of the list elements, without
a leading quote mark or a constructor name.

Finally, the @as-index{@onscreen{print} output} mode corresponds to
Racket's default printing via the @racket[print] procedure. Output via
@racket[print] is further configurable through run-time settings, such
as the @racket[print-as-expression] parameter, and it may be adjusted
by a @hash-lang[]-specified language. For example, the
@racketmodname[scheme] language sets the @racket[print-as-expression]
parameter to @racket[#f], which essentially makes @onscreen{print}
mode act like @onscreen{write} mode.

For any of the output styles, DrRacket sets the
@racket[global-port-print-handler] so that the @racket[print]
procedure produces output as selected.
